﻿namespace Code6587EN.Ch02.ApplyMasterToChannel
{
    using Microsoft.SharePoint;
    using System;
    using System.Collections;
    using System.Reflection;

    /// <summary>
    /// Console Application to apply a Master Page to a Device Channel
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Get the Site Collection in a Using statement
            using (var site = new SPSite("http://sharepoint/sitecollection"))
            {
                // Get the Mappings File type and constructor
                var typeMappingFile = Type.GetType("Microsoft.SharePoint.Publishing.Mobile.MasterPageMappingsFile, Microsoft.SharePoint.Publishing, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");                
                var consMappingFile = typeMappingFile.GetConstructor(new Type[] {typeof(SPWeb), typeof(bool), typeof(SPWeb)});

                // Get the root Site in a Using statement
                using (var web = site.RootWeb)
                {                   
                    // Get the Mapping File
                    var mappingFile = consMappingFile.Invoke(new object[] { web, false, null });
                    
                    // Get the Mappings and cast to an IDictionary
                    var mappings = (IDictionary)typeMappingFile.GetField("mappings", BindingFlags.Instance | BindingFlags.NonPublic).GetValue(mappingFile);

                    // Set the Master Page Url of the mapping object 
                    mappings["PowerShell"].GetType().GetProperty("MasterPageUrl", BindingFlags.Instance | BindingFlags.Public).SetValue(mappings["PowerShell"], "/_catalogs/masterpage/seattle.master", null);

                    // Set the updated Mappings on the Mappings file
                    typeMappingFile.GetField("mappings", BindingFlags.Instance | BindingFlags.NonPublic).SetValue(mappingFile, mappings);

                    // Get and invoke the Update Single Channel method
                    var updateMethod = typeMappingFile.GetMethod("UpdateSingleChannel", BindingFlags.Instance | BindingFlags.Public, null, new Type[] { typeof(string) }, null);
                    updateMethod.Invoke(mappingFile, new object[] { "PowerShell" });
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
